pro thread_the_scene,exchangefile,istarmin,istarmax

  ;Restore all of the data and then generate scene for stars 
  ;from istarmin to istarmax
  restore,filename=exchangefile
  for i=istarmin,istarmax do begin
  
     ;----- START OF STELLAR  FLUX -----
     ;First, some parameters specific to the star/system we will use later
     s = stars[i]

     print,'i = '+strcompress(string(i,format='(I0)'),/remove_all)
     print,'starID = '+strcompress(string(s.starID,format='(I0)'),/remove_all)


     
     hiptag = ''
     if s.HIP ge 0 then hiptag = strcompress(string(s.HIP),/remove_all)
     if strmid(output_dir,0,1) eq '/' then tempdir = output_dir else tempdir = exovistapath + output_dir ;if output_dir is relative or absolute
     fits_filename = tempdir + strcompress(string(s.starID),/remove_all)+'-HIP_'+hiptag+'-TYC_'+s.TYC+'-mv_'+strcompress(string(s.vmag,format='(F0.2)'),/remove_all)+'-L_'+strcompress(string(s.lstar,format='(F0.2)'),/remove_all)+'-d_'+strcompress(string(s.dist,format='(F0.2)'),/remove_all)+'-Teff_'+strcompress(string(s.teff,format='(F0.2)'),/remove_all)+'.fits'

     if not file_test(fits_filename) then begin

        print,tag_names(s)
        print,s.pa,s.i,s.dist
        print,s.bmag,s.vmag,s.rmag,s.imag,s.jmag,s.hmag,s.kmag
        print,s.m_v,s.type,s.lstar,s.teff,s.angdiam,s.mass,s.logg
        print,tag_names(s.disk[0])
        print,s.disk[0]
        print,s.disk[1]



     pixscale_AU = pixscale_arcsec * s.dist
     dstarAU = s.dist * 206265. ;distance to star in AU
     GM = grav_const*s.mass
     cosPA = cos(s.PA*pio180)
     sinPA = sin(s.PA*pio180)
     cosinc = cos(s.i*pio180)
     sininc = sin(s.i*pio180)

     ;Now get the stellar flux at the desired wavelengths
     fstar = get_stellar_flux(s,lambda,path=exovistapath)     
     ;----- END OF STELLAR FLUX -----

     
     ;----- START OF DISK IMAGING ----
     ;Now we image the disk
     disk_contrast_image = fltarr(npix,npix,nlambda_disk)
     ;Determine range of grain sizes for this star
     rdust_blowout = 0.5   ;this could be updated for each star, but that's kinda BS anyway
     minsize = rdust_blowout
     maxsize = (100*max(lambda)) < max(master_rdust_boundaries) ;100x wavelength if possible
     j = where(master_rdust gt minsize and master_rdust lt maxsize)
     if j[0] eq -1 then stop,'ERROR: no dust grain sizes meet your criteria.'
     nsizes = n_elements(j)
     rdust = master_rdust[j]
     drdust = master_drdust[j]
     rdust_boundaries = master_rdust_boundaries[min(j):max(j)+1]

     ;We need Qsca vs lambda for all grain sizes
     ;This has been previously calculated
     ;So we call a routine that loads this from a grid
     composition = 'astrosil'
     load_lqsca, lqq_dir, composition, rdust, rdust_boundaries, lambda_disk, Qsca
     ;Qsca is now nsizes x nlambda array

     ;Now distribute a grid of points and calculate disk flux at all points
     tsublimate = 1500.0 ;K
     disk_contrast_image = distribute_diskpoints(s, npix, pixscale_mas, rdust, drdust, rdust_blowout, Qsca, tsublimate, iwa, iwa_tol, seed)
     ;----- END OF DISK IMAGING -----
     

     ;----- START OF PLANET FLUX/INTEGRATION -----
     ;Now the planets

     ;First, retrieve the stellar flux at the native resolution of each planet     
     pfstar = fltarr(nfiles,nplambda)
     for ifile = 0,nfiles-1 do begin
        temp_lambda = plambda[ifile,*]
        temp_lambda = temp_lambda[where(temp_lambda gt 0)]
        tempfstar = get_stellar_flux(s,temp_lambda,path=exovistapath)     
        pfstar[ifile,0:n_elements(tempfstar)-1] = tempfstar
     endfor
     
     p = s.planet
     j = where(p.R ne 0)
     tempnplanets = 0
     if j[0] ne -1 then tempnplanets = n_elements(j)
     tempnplanets += 1 ;add 1 to include the star
     planet_data = fltarr(tempnplanets,15+nlambda,ntimes) ;this will hold all star + planet data vs time & wavelength
     
     if tempnplanets eq 1 then begin ;just the star
        ;if it's just the star, there's no integration to do
        ;just fill in planet_data with the time and flux
        for it = 0, ntimes-1 do begin
           planet_data[0,0,it] = double(it * dt)
           planet_data[0,1:2,it] = [npix/2.,npix/2.] ;pixel coordinates
           planet_data[0,15:(15+nlambda-1),it] = fstar ;flux
        endfor
     endif else begin           ;there are some valid planets, do the integration stuff
        tempp = p[j]
        
        Mplanet = tempp.m/332948.0 ;mass of planets in solar masses
        Mvector = double([s.mass,Mplanet]) ;all in solar masses
        GMplanet = grav_const * Mplanet
        GMplanetpstar = GMplanet + grav_const * s.mass
        ;Convert orbital elements to heliocentric coordinates
        cartesian, GMplanetpstar, tempp.a, tempp.e, tempp.i*pio180, tempp.longnode*pio180, tempp.argperi*pio180, tempp.meananom*pio180, xp, yp, zp, vxp, vyp, vzp
        ;Append star's heliocentric coordinates to the front
        x0 = double([0,xp])
        y0 = double([0,yp])
        z0 = double([0,zp])
        vx0 = double([0,vxp])
        vy0 = double([0,vyp])
        vz0 = double([0,vzp])
        ;Center of mass coordinates:
        cmx = total(x0*Mvector)/total(Mvector)
        cmy = total(y0*Mvector)/total(Mvector)
        cmz = total(z0*Mvector)/total(Mvector)
        cmvx = total(vx0*Mvector)/total(Mvector)
        cmvy = total(vy0*Mvector)/total(Mvector)
        cmvz = total(vz0*Mvector)/total(Mvector)
        ;Convert to barycentric coordinates before integrating
        x0 -= cmx
        y0 -= cmy
        z0 -= cmz
        vx0 -= cmvx
        vy0 -= cmvy
        vz0 -= cmvz
        ;x,y,z,vx,vy,vz are now vectors w/ star + planet's baryc. coords
        ;note that they are relative to the system's midplane

        
        ;Make sure variables are expected type for call to C below
        curr_time = double(0.0)
        desired_time = double(0.0)
        tempnplanets = long(tempnplanets)

        for it = 0, ntimes-1 do begin

           ;Integrate forward in time
           desired_time = double(it * dt) ;dt is in years           
           x = CALL_EXTERNAL(exovistapath+'nbody.so', 'nbody', $
                             curr_time, desired_time, tempnplanets, Mvector, x0, y0, z0, vx0, vy0, vz0)
           curr_time = desired_time ;update the time

           
           
           ;output coordinates are relative to the system plane

           ;Determine the new orbital parameters of the planets
           tempx = x0[1:tempnplanets-1] - x0[0] ;heliocentric coordinates of just the planets, not the star
           tempy = y0[1:tempnplanets-1] - y0[0]
           tempz = z0[1:tempnplanets-1] - z0[0]
           tempvx = vx0[1:tempnplanets-1] - vx0[0]
           tempvy = vy0[1:tempnplanets-1] - vy0[0]
           tempvz = vz0[1:tempnplanets-1] - vz0[0]
           keplerian, GMplanetpstar, tempx, tempy, tempz, tempvx, tempvy, tempvz, tempa, tempe, tempi, templongnode, tempargperi, tempmeananom
           tempi /= pio180 ;convert to degrees
           templongnode /= pio180
           tempargperi /= pio180
           tempmeananom /= pio180

           
           ;Convert output coordinates (relative to system midplane) to on-sky coordinates
           ;rotate about x-axis by system inclination
           xtemp = x0
           ytemp = y0 * cosinc + z0 * sininc
           ztemp = -y0 * sininc + z0 * cosinc
           vxtemp = vx0
           vytemp = vy0 * cosinc + vz0 * sininc
           vztemp = -vy0 * sininc + vz0 * cosinc
           ;rotate about z-axis by PA
           x = xtemp * cosPA - ytemp * sinPA ;AU
           y = xtemp * sinPA + ytemp * cosPA ;AU
           z = ztemp                      ;AU
           vx = vxtemp * cosPA - vytemp * sinPA ;AU
           vy = vxtemp * sinPA + vytemp * cosPA ;AU
           vz = vztemp                      ;AU

           ;Calculate flux
           x_helio = x - x[0] ;heliocentric coordinates
           y_helio = y - y[0]
           z_helio = z - z[0]
           xx_helio = x_helio*x_helio
           yy_helio = y_helio*y_helio
           zz_helio = z_helio*z_helio
           r_helio = sqrt(xx_helio+yy_helio+zz_helio)
           ;we assume telescope always points exactly at star
           dz = dstarAU - z_helio                         ; z-component of vector joining point to telescope
           l = sqrt(xx_helio + yy_helio + dz*dz)                   ; distance from point to telescope in AU
           cosbeta = (-z_helio*(dstarAU-z_helio) + xx_helio + yy_helio) / (r_helio * l) ; cos(phase angle) calculated from a dot product
           beta = acos(cosbeta)                           ; radians
           xpix = x_helio / pixscale_AU + npix/2. ;convert to pixel coordinates
           ypix = y_helio / pixscale_AU + npix/2.

           
           ;calculate flux from planet vs lambda
           ;Note: zeroth entry is the star
           for ip = 0, tempnplanets-1 do begin
              
              planet_data[ip,0,it] = curr_time
              planet_data[ip,1:2,it] = [xpix[ip],ypix[ip]]                       ;pixel coordinates
              planet_data[ip,9:14,it] = [x[ip],y[ip],z[ip],vx[ip],vy[ip],vz[ip]] ;barycentric coordinates
              
              if ip eq 0 then begin ;if it's the star...                
                 planet_data[ip,3:8,it] = 0. ;don't record a heliocentric orbit 
                 planet_data[ip,15:(15+nlambda-1),it] = fstar ;flux
              endif else begin ;if it's a planet... 
                 planet_data[ip,3:8,it] = [tempa[ip-1],tempe[ip-1],tempi[ip-1],templongnode[ip-1],tempargperi[ip-1],tempmeananom[ip-1]] ;record the heliocentric orbit
                 j = where(tempp[ip-1].albedo_file eq albedo_files)
                 if j[0]  eq -1 then stop,'ERROR! Cannot locate albedo file '+tempp[ip-1].albedo_file

                 ;Explicitly calculate the contrast
                 templambda = plambda[j[0],*]
                 tempg = pgeometric_albedos[j[0],*]
                 tempfstar = pfstar[j[0],*]
                 k = where(templambda ne 0)
                 templambda = templambda[k]
                 tempg = tempg[k]
                 tempfstar = tempfstar[k]
                 tempnu = (2.998e14)/templambda ;frequency in Hz
                 tempdnu = abs(tempnu[1:n_elements(tempnu)-1]-tempnu[0:n_elements(tempnu)-2]) ;will use this for integration
                 
                 phi = lambertian(beta[ip])
                 Rpor = (tempp[ip-1].R * 4.2635e-5) / r_helio[ip] ;planet radius in AU divided by circumstellar distance in AU
                 tempfp = (tempfstar * tempg) * (phi * Rpor * Rpor)
                 ;Now, planet flux Fp is at the native
                 ;resolution of the planet's
                 ;geometric albedo file. We need to
                 ;bin it to the final output resolution.
                 ;To do this we integrate flux over
                 ;all values within the spectral channel.
                 integratedFp = fltarr(nlambda)
                 for ilambda=0,n_elements(lambda)-1 do begin
                    j = where(templambda ge transition_lambda[ilambda] and templambda lt transition_lambda[ilambda+1])
                    integratedFp[ilambda] = total(tempfp[j] * tempdnu[j]) / total(tempdnu[j]) ;integrate over spectral channel and divide by total dnu
                 endfor
                 cp = integratedFp / fstar ;convert to contrast by dividing by recorded fstar
                 planet_data[ip,15:(15+nlambda-1),it] = cp ;contrast
                 

                 ;---outdated old method----
                 ;we just use the geometric albedo
                 ;g = geometric_albedos[j[0],*] ;this is the planet's geomtric albedo vs lambda
                 ;phi = lambertian(beta[ip])
                 ;Rpor = (tempp[ip-1].R * 4.2635e-5) / r_helio[ip] ;planet radius in AU divided by circumstellar distance in AU
                 ;;fp = (fstar * g) * (phi * Rpor * Rpor) ;planet flux        
                 ;cp = g * (phi * Rpor * Rpor)           ;planet contrast
                 ;planet_data[ip,15:(15+nlambda-1),it] = cp ;contrast



              endelse

              
           endfor

        endfor
     endelse
     ;----- END OF PLANET FLUX/INTEGRATION -----
     



         



     ;---------------------------
     ;   CREATE FITS FILE
     ;---------------------------
     ;Now we create the fits file
     ;write main header and first extension = lambda array
     undefine,h
     ;file_delete,fits_filename,/allow_nonexistent ;*************
     ;First extension will be star/planet wavelength vector
     writefits,fits_filename,lambda,h
     j = where(p.R) ne 0
     tempnp = 0
     if j[0] ne -1 then tempnp = n_elements(j)
     sxaddpar,h,'N_EXT',3+tempnp,'Last extension' ;need to add this to the main header to enable extensions
     sxaddpar,h,'SPECRES',specres,'Spectral resolution of star and planet wavelengths'
     sxaddpar,h,'LAMMIN',lambdamin,'Minimum wavelength (microns)'
     sxaddpar,h,'LAMMAX',lambdamax,'Maximum wavelength (microns)'
     sxaddhist,'Stellar wavelength vector',h,/comment
     modfits,fits_filename,lambda,h
     
     ;append disk wavelength vector as another extension
     mkhdr, h, lambda_disk, /image, /extend
     sxaddpar,h,'SPECRES',specrdisk,'Spectral resolution of disk wavelengths'
     sxaddpar,h,'LAMMIN',lambdamin,'Minimum wavelength (microns)'
     sxaddpar,h,'LAMMAX',lambdamax,'Maximum wavelength (microns)'
     sxaddhist,'Disk wavelength vector',h,/comment
     writefits,fits_filename,lambda_disk,h,/append
     
     ;append disk contrast cube as another extension
     mkhdr, h, disk_contrast_image, /image, /extend
     sxaddpar, h, 'NCOMP', ncomponents,'Number of disk components'
     sxaddpar, h, 'PXSCLMAS', pixscale_mas,'Pixel scale (mas)'
     for icomp = 0, ncomponents-1 do begin
        d = s.disk[icomp]
        temp = tag_names(d)
        for ih = 0,n_elements(temp)-1 do begin
           comment = ''
           if temp[ih] eq 'LONGNODE' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' longitude of ascending node (deg)'
           if temp[ih] eq 'I' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' inclination (deg)'
           if temp[ih] eq 'NZODIS' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' exozodi level (zodis)'
           if temp[ih] eq 'R' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' peak density radius (AU)'
           if temp[ih] eq 'DROR' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' Gaussian peak width'
           if temp[ih] eq 'RINNER' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' truncation radius (AU)'
           if temp[ih] eq 'ETA' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' T_PR/T_coll'
           if temp[ih] eq 'HOR' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' scale height'
           if temp[ih] eq 'G' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' HG scattering asymmetry parameter'
           if temp[ih] eq 'W' then comment='Disk comp. '+strcompress(string(icomp,format='(I0)'),/remove_all)+' HG function weight'
          
           if temp[ih] eq 'LONGNODE' then temp[ih] = 'LNGND'
           if n_elements(d.(ih)) le 1 then begin
              sxaddpar,h,temp[ih]+'-'+strcompress(string(icomp,format='(I0)'),/remove_all),d.(ih),comment
           endif else begin
              for idummy = 0, n_elements(d.(ih))-1 do begin
                 sxaddpar,h,temp[ih]+strcompress(string(idummy,format='(I0)'),/remove_all)+'-'+strcompress(string(icomp,format='(I0)'),/remove_all),d.(ih)[idummy],comment
              endfor
           endelse
        endfor
     endfor
     sxaddpar, h, 'MINSIZE', min(rdust_boundaries), 'Minimum grain size (microns)'
     sxaddpar, h, 'MAXSIZE', max(rdust_boundaries), 'Maximum grain size (microns)'
     sxaddpar, h, 'COMPOSIT', composition, 'Dust composition'
     sxaddhist,'Disk contrast cube',h,/comment
     writefits,fits_filename,disk_contrast_image,h,/append ;now write to disk
     
     ;append star as its own extension
     ip=0
     temp_star_data = float(reform(planet_data[ip,*,*])) ;grab the data for this particular planet           
     mkhdr, h, temp_star_data, /image, /extend
     temp = tag_names(s)
     for ih = 0,n_elements(temp)-1 do begin
        comment = ''
        if temp[ih] eq 'HIP' then comment='Hipparcos designation'
        if temp[ih] eq 'TYC' then comment='Tycho-2 designation'
        if temp[ih] eq 'PA' then comment='System midplane position angle (deg)'
        if temp[ih] eq 'I' then comment='System midplane inclination (deg)'
        if temp[ih] eq 'STARID' then comment='Internal catalog #'
        if temp[ih] eq 'RA' then comment='Right ascension (decimal deg)'
        if temp[ih] eq 'DEC' then comment='Declination (decimal deg)'
        if temp[ih] eq 'M_V' then comment='Absolute V band mag'
        if temp[ih] eq 'DIST' then comment='Distance (pc)'
        if temp[ih] eq 'RA' then comment='Right ascension (decimal deg)'
        if temp[ih] eq 'TYPE' then comment='Spectral type'
        if temp[ih] eq 'LSTAR' then comment='Bolometric luminosity (solar luminosities)'
        if temp[ih] eq 'TEFF' then comment='Effective temperature (K)'
        if temp[ih] eq 'ANGDIAM' then comment='Angular diameter (mas)'
        if temp[ih] eq 'MASS' then comment='Mass (solar masses)'
        if temp[ih] eq 'RSTAR' then comment='Radius (solar radii)'
        if temp[ih] eq 'WDS_SEP' then comment='Seperation of WDS catalog companion (arcsec)'
        if temp[ih] eq 'WDS_DMAG' then comment='Delta mag of WDS catalog companion'
        if temp[ih] eq 'PMRA' then comment='Proper Motion RA (mas/yr)'
        if temp[ih] eq 'PMDEC' then comment='Proper Motion Dec (mas/yr)'

        if temp[ih] ne 'PLANET' and temp[ih] ne 'DISK' then sxaddpar,h,temp[ih],s.(ih),comment
     endfor
     sxaddpar, h, 'PXSCLMAS', pixscale_mas, 'Pixel scale (mas)'
     sxaddhist,'Star data array',h,/comment
     writefits,fits_filename,temp_star_data,h,/append ;write only this planet
     
     ;append each existing planet as its own extension
     for ip=1, tempnplanets-1 do begin
        temp_planet_data = float(reform(planet_data[ip,*,*])) ;grab the data for this particular planet           
        mkhdr, h, temp_planet_data, /image, /extend
        sxaddpar, h, 'M', tempp[ip-1].M, 'Mass (Earth masses)'
        sxaddpar, h, 'R', tempp[ip-1].R, 'Radius (Earth radii)'
        sxaddpar, h, 'ALBEDO_F', tempp[ip-1].ALBEDO_FILE, 'Geometric albedo file'
        sxaddpar, h, 'A', tempp[ip-1].A, 'Semi-major axis (AU)'
        sxaddpar, h, 'E', tempp[ip-1].E, 'Eccentricity'
        sxaddpar, h, 'I', tempp[ip-1].I, 'Inclination (deg)'
        sxaddpar, h, 'LONGNODE', tempp[ip-1].LONGNODE, 'Longitude of ascending node (deg)'
        sxaddpar, h, 'ARGPERI', tempp[ip-1].ARGPERI, 'Argument of pericenter (deg)'
        sxaddpar, h, 'MEANANOM', tempp[ip-1].MEANANOM, 'Mean anomaly (deg)'
        sxaddpar, h, 'PXSCLMAS', pixscale_mas, 'Pixel scale (mas)'
        sxaddhist,'Planet data array',h,/comment
        writefits,fits_filename,temp_planet_data,h,/append ;write only this planet
     endfor


     endif
  endfor
end
