function sag13_eta_grid, r_vec=r_vec,p_vec=p_vec,a_vec=a_vec,nbins=nbins,rmin=rmin,rmax=rmax,amin=amin,amax=amax

  ;creates a grid of eta values
  ;planet radius is along y axis
  ;planet semi-major axis is along x axis
  
  if n_elements(rmin) eq 0 then rmin = 0.5
  if n_elements(rmax) eq 0 then rmax = 11.6
  if n_elements(amin) eq 0 then amin = 1./sqrt(185.)
  if n_elements(amax) eq 0 then amax = 1./sqrt(0.0055)

  if n_elements(nbins) eq 0 then nbins = 1000
  ;if nbins lt 1000 then begin
  ;   print,'nbins is small.  The grid is coarse.'
  ;   pause
  ;endif

  ;For mean SAG13 results:
  gamma_i = [0.38,0.73]
  alpha_i = [-0.19,-1.18]
  beta_i = [0.26,0.59]
  r_crit = 3.4

  ;For "1-sigma" lower limit:
  llgamma_i = [0.138,0.72]
  llalpha_i = [0.277,-1.58]
  llbeta_i = [0.204,0.51]
  llr_crit = 3.4
  
  ;For "1-sigma" upper limit:
  ulgamma_i = [1.06,0.78]
  ulalpha_i = [-0.68,-0.82]
  ulbeta_i = [0.32,0.67]
  ulr_crit = 3.4
  
  r_vec = exp(findgen(nbins)/(nbins-1.)*(alog(rmax)-alog(rmin)) + alog(rmin))
  lnr_vec = alog(r_vec)
  dlnr_vec = lnr_vec[1:n_elements(lnr_vec)-1]-lnr_vec[0:n_elements(lnr_vec)-2]
  midlnr_vec = (lnr_vec[1:n_elements(lnr_vec)-1]+lnr_vec[0:n_elements(lnr_vec)-2])/2.
  midr_vec = exp(midlnr_vec)
  
  pmin = amin^(1.5)
  pmax = amax^(1.5)
  p_vec = exp(findgen(nbins)/(nbins-1.)*(alog(pmax)-alog(pmin)) + alog(pmin))
  a_vec = p_vec^(2./3.)
  lnp_vec = alog(p_vec)
  dlnp_vec = lnp_vec[1:n_elements(lnp_vec)-1]-lnp_vec[0:n_elements(lnp_vec)-2]
  midlnp_vec = (lnp_vec[1:n_elements(lnp_vec)-1]+lnp_vec[0:n_elements(lnp_vec)-2])/2.
  midp_vec = exp(midlnp_vec)

  
  eta_array = fltarr(n_elements(midr_vec),n_elements(midp_vec),3)
  for ir=0,n_elements(midr_vec)-1 do begin
     ;Lower limit
     if midr_vec[ir] le llr_crit then tempindex = 0 else tempindex = 1
     for ip=0,n_elements(midp_vec)-1 do begin
        eta_array[ip,ir,0] = llgamma_i[tempindex] * midr_vec[ir]^(llalpha_i[tempindex]) * midp_vec[ip]^(llbeta_i[tempindex]) * dlnr_vec[ir] * dlnp_vec[ip]
     endfor
     ;Expected value
     if midr_vec[ir] le r_crit then tempindex = 0 else tempindex = 1
     for ip=0,n_elements(midp_vec)-1 do begin
        eta_array[ip,ir,1] = gamma_i[tempindex] * midr_vec[ir]^(alpha_i[tempindex]) * midp_vec[ip]^(beta_i[tempindex]) * dlnr_vec[ir] * dlnp_vec[ip]
     endfor
     ;Upper limit
     if midr_vec[ir] le ulr_crit then tempindex = 0 else tempindex = 1
     for ip=0,n_elements(midp_vec)-1 do begin
        eta_array[ip,ir,2] = ulgamma_i[tempindex] * midr_vec[ir]^(ulalpha_i[tempindex]) * midp_vec[ip]^(ulbeta_i[tempindex]) * dlnr_vec[ir] * dlnp_vec[ip]
     endfor
  endfor
  return,eta_array
  
end
