function rgen, numx, numy, x=x, y=y

  ; Generates a 2D distribution of radii.  The origin is assumed
  ; to be in the center of the matrix.  Radii are calculated
  ; assuming 1 pixel = 1 unit.  The number of pixels can be odd
  ; or even.

  ; numx = # of pixels in x direction
  ; numy = # of pixels in y direction
  ; x: the x coordinates
  ; y: the y coordinates

  xo2 = numx/2

  if n_elements(numy) eq 0 then numy = numx
  yo2 = numy/2

  xn1 = xo2
  xn2 = xo2-1
  yn1 = yo2
  yn2 = yo2-1

  oddx = 0
  oddy = 0
  if (xo2 + xo2) lt numx then begin
     oddx = 1
     xn2 = xo2
     xo2 += 1
  endif
  if (yo2 + yo2) lt numy then begin
     oddy = 1
     yn2 = yo2
     yo2 += 1
  endif

  xa = dindgen(xo2) + double(0.5)
  ya = dindgen(yo2) + double(0.5)
  if oddx then xa -= double(0.5)
  if oddy then ya -= double(0.5)

  xb = rebin(xa, xo2, numy)
  yb = rotate(rebin(ya, yo2, numx),1) ;rotate by 90 deg CCW  


  x = fltarr(numx,numy)
  x[xn1:numx-1,0:numy-1] = xb
  x[0:xn2,0:numy-1] = -rotate(xb,2)

  y = fltarr(numx,numy)
  y[0:numx-1,yn1:numy-1] = yb
  y[0:numx-1,0:yn2] = -rotate(yb,2)

  r = sqrt(x*x+y*y)

  return,r
end
