function mass_to_radius, M

  ;Calculate radius in Earth radii based on Chen & Kipping (2017)

  R = 1.008 *M^0.279
  j = where(M gt 2.04)
  if j[0] ne -1 then R[j] = (1.008 * (2.04^0.279)) * (M[j]/2.04)^0.589
  j = where(M gt 131.6)
  if j[0] ne -1 then R[j] = (1.008 * (2.04^0.279) * (131.6/2.04)^0.589) * (M[j]/131.6)^(-0.044)

  return, R

end
