pro load_target_list_from_scratch, target_list_file, target_list, hips=hips, quiet=quiet

nheaderlines = 2
openr, lun, target_list_file, /get_lun
n = file_lines(target_list_file)-nheaderlines
header = strarr(nheaderlines)
target_list = replicate({targetlistfromscratchdata, starID:0L, HIP:0L, TYC:'', RA:0., DEC:0., $
                         Umag:0., Bmag:0., Vmag:0., Rmag:0., Imag:0., Jmag:0., Hmag:0., Kmag:0., $
                         M_V:0., dist:0., Type:'', Lstar:0.0, Teff:0.0, angdiam:0.0, mass:0.0, logg:0.0, rstar:0.0, WDS_sep:0.0, WDS_dmag:0.0, $
                         pmRA:0., pmDEC:0.}, n)
readf, lun, header
hips = lonarr(n)

for i=0,n-1 do begin
   line = ''
   readf, lun, line
   line = strcompress(strsplit(line,'|', /EXTRACT),/remove_all)

   target_list[i].starID = long(line[0])
   target_list[i].HIP = long(line[1])
   target_list[i].TYC = line[2]
   target_list[i].RA = float(line[4])
   target_list[i].DEC = float(line[5])
   target_list[i].umag = float(line[6]) ;apparent magnitudes
   target_list[i].bmag = float(line[7])
   target_list[i].vmag = float(line[8])
   target_list[i].rmag = float(line[9])
   target_list[i].imag = float(line[10])
   target_list[i].jmag = float(line[11])
   target_list[i].hmag = float(line[12])
   target_list[i].kmag = float(line[13])
   target_list[i].dist = float(line[14])
   target_list[i].M_V = float(line[15]) ;absolute V magnitude
   target_list[i].Type = line[16]
   target_list[i].Lstar = float(line[17]) ;Lsun
   target_list[i].WDS_sep = float(line[18]) ;arcsec
   target_list[i].WDS_dmag = float(line[19]) ;mags
   target_list[i].pmRA = float(line[20]) ;mas/yr
   target_list[i].pmDEC = float(line[21]) ;mas/yr
   
   ;Calculate a couple of quantities...
   target_list[i].mass = (target_list[i].Lstar)^(1./3.5) ;FIX THIS UPDATE THIS TEMORARY
   BmV = target_list[i].bmag - target_list[i].vmag
   Vmag = target_list[i].Vmag
   logthetastar_mveq0 = 0.49612 + 1.11136*BmV^1. - 1.18694*BmV^2. + 0.91974*BmV^3. - 0.19526*BmV^4. ;From Eq 2 and Table 1 in Boyajian et al. 2014, valid for LC IV and V stars
   logthetastar_LD = logthetastar_mveq0 - 0.2*Vmag
   target_list[i].angdiam = 10.^logthetastar_LD ;star angular diameter in mas 


   hips[i] = long(line[1])
endfor

free_lun, lun

end
