pro load_stars, target_list, quiet=quiet

  
   target_list_file = 'master_target_list-usingDR2-50_pc.txt'
   if not keyword_set(quiet) then print,format='("Loading target list...",$)'
   load_target_list_from_scratch, target_list_file, target_list, quiet=quiet  
   
   target_list = target_list[where(finite(target_list.Lstar) eq 1 and target_list.Lstar lt 100 and target_list.Lstar gt 0)]
   target_list = target_list[where(finite(target_list.M_V) eq 1)]
   target_list = target_list[where(finite(target_list.dist) eq 1)]
   target_list = target_list[where(finite(target_list.vmag) eq 1)] ;must have vmag
   target_list = target_list[where(finite(target_list.umag) eq 1 or finite(target_list.bmag) eq 1)] ;must have photometry at one shorter wavelength
   target_list = target_list[where(finite(target_list.rmag) eq 1 or finite(target_list.imag) eq 1 or finite(target_list.jmag) eq 1 or finite(target_list.hmag) eq 1 or finite(target_list.kmag))] ;must have photometry at one longer wavelength
   ;Require the star to have a classified temperature (to avoid odd-balls)
   target_list = target_list[where(strmatch(strmid(target_list.type,0,1),'[obafgkm]',/fold_case) eq 1)]
   ;Can't be a giant--this finds all I, II, and IIIs without catching the IVs
   target_list = target_list[where((strmatch(target_list.type,'*I*') - strmatch(target_list.type,'*IV*')) ne 1)]
   ;The above keeps ALL IVs, so if a star is listed as, e.g. G0III-IV,
   ;it is kept.  But I want to be conservative, so I will filter out those, too...
   target_list = target_list[where(strmatch(target_list.type,'*II*') ne 1)]      



   ;Let's use Eric Mamajek's table of MS stars to interpolate mass and
   ;effective temperature
   data = read_ascii('mamajek_dwarf.txt',comment_symbol='#')
   data = data.field01
   mamajeklogT = data[2,*]
   mamajeklogL = data[3,*]
   mamajekBmV = data[7,*]
   mamajeklogM = alog10(data[29,*])
   j = where(finite(mamajekBmV) eq 1 and finite(mamajeklogM) eq 1 and finite(mamajeklogT) eq 1 and mamajekBmV gt -3.2)
   mamajeklogT = mamajeklogT[j]
   mamajeklogL = mamajeklogL[j]
   mamajekBmV = mamajekBmV[j]
   mamajeklogM = mamajeklogM[j]
   j = sort(mamajekBmV)
   mamajeklogT = mamajeklogT[j]
   mamajeklogL = mamajeklogL[j]
   mamajekBmV = mamajekBmV[j]
   mamajeklogM = mamajeklogM[j]
   target_list[*].mass = 10.^(interpol(mamajeklogM,mamajekBmV,target_list.Bmag-target_list.Vmag))
   target_list[*].Teff = 10.^(interpol(mamajeklogT,mamajekBmV,target_list.Bmag-target_list.Vmag))


   ;Now calculate log(g)
   rsunAU = 0.00465047                                            ;AU
   rstarAU = target_list[*].dist * (target_list[*].angdiam/1000.) ;in AU (angdiam is in mas)
   target_list[*].rstar = rstarAU / rsunAU / 2.0
   target_list[*].logg = alog10(target_list[*].mass) - 2*alog10(target_list[*].rstar) + 4.437
 
   ;Dustmap can't handle logg > 5.25
   j = where(target_list[*].logg lt 5.24)
   target_list = target_list[j]
   
   if not keyword_set(quiet) then print,'done.'

   
end
