pro load_lqsca, lqq_dir, composition, rdust, rdust_boundaries, lambda, Qsca_array

  ;lqq_dir: directory (including /) of lqq files
  ;composition: composition of dust (string)
  ;rdust: grain size in microns
  ;rdust_boundaries: upper and lower limits of rdust bin in microns
  ;lambda: desired wavelengths in microns
  ;Qsca: returned nsizes x nlambda array
  
  nsizes = n_elements(rdust)
  nlambda = n_elements(lambda)
  Qsca_array = fltarr(nsizes,nlambda)
  
  lqq_files = lqq_dir+composition+'-s_'+strcompress(string(rdust,format='(F0.4)'),/remove_all)+'-smin_'+strcompress(string(rdust_boundaries[0:nsizes-1],format='(F0.4)'),/remove_all)+'-smax_'+strcompress(string(rdust_boundaries[1:nsizes],format='(F0.4)'),/remove_all)+'-dnds~s^-3.5.lqq'

  for i=0,nsizes-1 do begin

     lqq_file = lqq_files[i]

     ;read the file
     d = read_ascii(lqq_file,COMMENT_SYMBOL='#')
     d = d.(0)
     l = d[0,*]
     qsca = d[2,*]

     ;interpolate to desired wavelengths
     Qsca_array[i,*] = interpol(qsca,l,lambda,/spline)
  endfor
  
end
