function lambertian, beta

  ;Returns the value of the Lambert phase function
  ;beta = phase angle in radians
  ;See, e.g., R. Brown (2005) "Sing-Visit Photometric
  ;and Obscurational Completeness" Eq 4

  oneopi = 1. / !dpi
  phi = (sin(beta) + (!dpi-beta) * cos(beta)) * oneopi

  return, phi

end
