pro keplerian,GM, x, y, z, vx, vy, vz, a, e, i, longnode, argperi, meananom
  
;NOTE: this does not correctly calculate the meananom (or eccanom) for
;a hyperbolic orbit

  ;find direction of angular momentum vector
  rxv_x = y * vz - z * vy
  rxv_y = z * vx - x * vz
  rxv_z = x * vy - y * vx
  hs = rxv_x * rxv_x + rxv_y * rxv_y + rxv_z * rxv_z
  h = sqrt(hs)

  r = sqrt(x * x + y * y + z * z)
  vs = vx * vx + vy * vy + vz * vz
  rdotv = x * vx + y * vy + z * vz
  rdot = rdotv / r
  parameter = hs / GM

  i = acos(rxv_z / h)

  longnode = i * 0.0 ;zero by default
  j = where(rxv_x ne 0 or rxv_y ne 0)
  if j[0] ne -1 then longnode[j] = atan(rxv_x, -rxv_y)

  a = 1.0 / (2.0 / r - vs / GM)

  ecostrueanom = parameter / r - 1.0
  esintrueanom = rdot * h / GM
  e = sqrt(ecostrueanom * ecostrueanom + esintrueanom * esintrueanom);

  trueanom = i * 0.0 ;zero by default
  j = where(esintrueanom ne 0 or ecostrueanom ne 0)
  if j[0] ne -1 then trueanom[j] = atan(esintrueanom, ecostrueanom)

  cosnode = cos(longnode)
  sinnode = sin(longnode)

  ;u is the argument of latitude
  rcosu = x * cosnode + y * sinnode
  rsinu = (y * cosnode - x * sinnode)/cos(i)

  u = i * 0.0 ;zero by default
  j = where(rsinu ne 0 or rcosu ne 0)
  if j[0] ne -1 then u[j] = atan(rsinu, rcosu)

  argperi = u - trueanom

  eccanom = 2.0 * atan(sqrt((1.0 - e)/(1.0 + e)) * tan(trueanom/2.0))
  meananom = eccanom - e * sin(eccanom)

end
