pro example_image

  fitsfile = './output/7-*.fits'
  
  ;Load the scene at the desired time
  time = 0
  load_scene, fitsfile, lambda=lambda, xystar=xystar, fstar=fstar, xyplanet=xyplanet, fplanet=fplanet, diskimage=diskimage, time=time, pixscale=pixscale
  ;pixscale is in mas
  nlambda = n_elements(lambda)
  nplanets = n_elements(xyplanet[*,0])
  npix = size(diskimage,/dim)
  npix = npix[0]
 
  ;Now load your model PSFs for the planet
  ;Note that it's much faster to pre-load these now
  ;than inside of a loop when you need them later
  ;pixscale is in mas (consistent w/ disk image loaded above)
  diameter = 10.                ;diameter of telescope in m 
  modelpsfs = fltarr(npix,npix,nlambda)
  for ilambda=0,nlambda-1 do begin
     psf, lambda[ilambda], diameter, npix, pixscale, modelpsf
     modelpsfs[*,*,ilambda] = modelpsf
  endfor


  ;Now form the image
  image = fltarr(npix,npix,nlambda)

  ;Add each planet at every wavelength
  for ip=0,nplanets-1 do begin
     x = xyplanet[ip,0]
     y = xyplanet[ip,1]
     for ilambda=0,nlambda-1 do begin
        modelpsf = reform(modelpsfs[*,*,ilambda])
        modelpsf = rot(modelpsf,0,1,npix-x,npix-y,cubic=-0.5)
        modelpsf *= fplanet[ip,ilambda]
        image[*,*,ilambda] += modelpsf
     endfor
  endfor

  ;Add the disk
  image += diskimage

  tvscl,image[*,*,0]^0.1

     
end
