function distribute_diskpoints, s, npix, pixscale_mas, rdust, drdust, rdust_blowout, Qsca, tsublimate, iwa, iwa_tol, seed, quiet=quiet

  seed = systime(/sec)

  
  ;Tolerance is set to give noise level at 1/3rd of faintest
  ;detectable point source (dmag=26.5) at V band for a 4 m
  ;telescope. 

  tol = 0.05/max(s.disk.nzodis)
  tol = tol > 0.0005 ;if nzodis>100, we're not going to be looking for dmag=26.5 objects anyway
  tol = tol < 0.05 ;at least hit 5% precision even if nzodis is < 1
  tol0 = tol

  
  pixscale_arcsec = pixscale_mas / 1000.
  auperpix = double(pixscale_arcsec * s.dist)
  pio180 = !dpi/double(180.0)
  cosinc = cos(-s.i*pio180) ;we want to rotate in opposite direction of inclination
  sininc = sin(-s.i*pio180)
  cosPA = cos(-s.PA*pio180) ;we want to rotate in opposite direction of inclination
  sinPA = sin(-s.PA*pio180)
  distAU = s.dist * double(206265.0); distance to star in AU
  nlambda = size(Qsca,/dim)
  nlambda = nlambda[1]

  
  masterimg = dblarr(npix,npix,nlambda)
  precision = dblarr(npix,npix)
  
  ;Old zmax calculation that don't use anymore:
  ;zmax = 2*max(s.disk[*].r)*abs(sininc) > 4*max(s.disk[*].hor)*(npix/2.*auperpix)*abs(cosinc)

  ;go far enough that expected SB drops to tol of peak
  
  zmax_radial = max(s.disk[*].r)*tol^(-2./7.) ;based on n ~ r^-1.5 and 1/r^2 illumination factor
  rmax = sqrt(2)*(npix/2.0)*auperpix
  zmax_height = sqrt(-2 * (max(s.disk[*].hor) * rmax)^2 * alog(tol)) ;exponential variation with z


  ;;We use zmax_height (z limit based on tol and opening angle of disk) 
  ;;to estimate inc0, which is the inclination at which we start looking
  ;;through the radial extent of the disk. The 1.25 factor is a buffer.
  ;inc0 = (90. - 1.25 * atan(zmax_height/rmax)*180./!dpi)
  ;;If we're not inclined by that much, we just have to based zmax
  ;;on the maximum height / abs(cosinc)
  ;if acos(abs(cosinc)) lt inc0*pio180 then begin
  ;   zmax = zmax_height/abs(cosinc)
  ;endif else begin ;otherwise we have to base it on the radial drop-off
  ;   zmax = zmax_radial
  ;endelse

  zmax = zmax_radial;*abs(sininc) > zmax_height*abs(cosinc)

  ;The newest version of determining zmax:
  ;rsurf = findgen(100*max(s.disk[*].r))*0.1
  ;zsurf = max(s.disk[*].hor) * rsurf * sqrt(-2*alog(tol) - 7*alog(rsurf/max(s.disk[*].r)))
  ;j = where(finite(zsurf eq 1))
  ;if j[0] eq -1 then stop,'ERROR in determining zmax.'
  ;rsurf = rsurf[j]
  ;zsurf = zsurf[j]
  ;rsurf = [rsurf,reverse(rsurf)]
  ;zsurf = [zsurf,-reverse(zsurf)]
  ;zsurf_rot = zsurf*sininc-rsurf*cosinc
  ;rsurf_rot = zsurf*cosinc+rsurf*sininc
  ;zmax = max(abs(rsurf_rot))

  
  print,'zmax_radial = ',zmax_radial
  print,'zmax_height = ',zmax_height
  print,'inc = ',s.i
  print,'zmax = ',zmax
  
  r = rgen(npix,npix,x=x0,y=y0)
  x0 -= double(0.5) ;shift to 00LL convention
  y0 -= double(0.5) ;shift to 00LL convention
  x0 *= auperpix ;convert to AUs
  y0 *= auperpix ;convert to AUs

  r_arcsec = r * pixscale_arcsec
  
  ;We do this on a pixel-by-pixel basis
  ;because otherwise it takes too much RAM
  dx0 = double(auperpix)                 ;in AUs
  dy0 = double(auperpix)                 ;in AUs
  prevnxy = 0
  prevnz = 0

  
  tstart = systime(/sec)
  nsubarraypix = 1
  bksp = ''
  for ix=0,npix-1,nsubarraypix do begin

     ;if ix gt 0 then bksp = make_array( strlen(updatestring), VALUE = 8B )
     ;updatestring = '  Progress: ' + strcompress(string(((ix+1.0)/npix)*100,format='(I0)'),/remove_all)+'% complete'
     ;if not keyword_set(quiet) then print,format='(a,a,$)',string(bksp),updatestring

     maxnxy_used = 0
     maxnz_used = 0
     for iy=0,npix-1,nsubarraypix do begin

        ;reduce tolerance on pixels interior to iwa
        ;this significantly improves run time
        ;and memory usage, as most time is spent
        ;on the central pixels
        if r_arcsec[ix,iy] lt iwa then tol = iwa_tol > tol0 else tol = tol0
        
        nxy = long(1);(prevnxy-2) > long(1)
        nz = long(128);(prevnz/4) > long(100)
        maxnxy = long(32) ;the highest nxy can ever get
        maxnz = long(32768)     ;the higest nz can ever get
        prevnxy = 0
        prevnz = 0
        iteration = long(0)
        finished_this_pixel = 0
        limit_flag = 0
        while finished_this_pixel ne 2 do begin

           
           ;update the dvolume values based on # of sub-points
           dx = dx0/nxy
           dy = dy0/nxy

           ;create x and y sub-coordinates

           x = (dindgen(nxy*nsubarraypix))/nxy+double(0.5)/nxy
           x *= auperpix
           x = rebin(x,nxy*nsubarraypix,nxy*nsubarraypix) ;now a 2D array
           y = rotate(x,1)
           x += x0[ix,iy]
           y += y0[ix,iy]
           
           subpixelrows = indgen(nsubarraypix)*nxy
           x = rebin(x,nxy*nsubarraypix,nxy*nsubarraypix,nz) ;make 3D
           y = rebin(y,nxy*nsubarraypix,nxy*nsubarraypix,nz)    ;make 3D

           
           ;Linear dz: this takes too long
           ;dz = (2*zmax)/nz
           ;zvals_vector = (dindgen(nz)+0.5)*dz-zmax
           ;z = dblarr(1,1,nz)
           ;z[0,0,*] = zvals_vector
           ;z = rebin(z,nxy*nsubarraypix,nxy*nsubarraypix,nz)
           ;dz = rebin([dz],nxy*nsubarraypix,nxy*nsubarraypix,nz)           
           

           ;dz ~ z^zpower method: this is faster and provides better resolution
           ;near the disk midplane typically
           zpower = double(2.0)
           dz = double(2.0)/nz
           zvals_vector = (dindgen(nz+1))*dz-1 ;array of endpoints of volumes
           zvals_vector *= zmax^(double(1.0)/(zpower+1))
           zvals_vector = zvals_vector*abs(zvals_vector)^(zpower)
           dzvals_vector = abs(zvals_vector[1:nz]-zvals_vector[0:nz-1]) 
           zvals_vector = (zvals_vector[1:nz]+zvals_vector[0:nz-1])*double(0.5) ;midpoint
           z = dblarr(1,1,nz)
           z[0,0,*] = zvals_vector
           z = rebin(z,nxy*nsubarraypix,nxy*nsubarraypix,nz)
           dz = dblarr(1,1,nz)
           dz[0,0,*] = dzvals_vector
           dz = rebin(dz,nxy*nsubarraypix,nxy*nsubarraypix,nz)           
           
           dv = dx*dy*dz

           ;now we have nxy x nxy lines of sight in our pixel
           ;resolved into nz steps along the line of sight

           ;calculate scattering angle
           r = sqrt(x*x+y*y+z*z)
           l = sqrt(x*x+y*y+distAU*distAU)
           cosscattang = ((-x*x - y*y + z*distAU) / (r * l))
           
           
           ;Transform sky-plane xyz coords to disk-plane coords.
           ;Normally we do the reverse. So here we have to           
           ;perform the rotations in the opposite order
           ;and opposite direction as normal. Note that 
           ;sininc/cosinc and sinPA/cosPA have already been 
           ;calculated w/ the opposite sign included.
           ;rotate about z-axis by -PA
           xtemp = x * cosPA - y * sinPA ;AU
           ytemp = x * sinPA + y * cosPA ;AU
           ztemp = z                      ;AU
           ;using the opposite signs
           x = xtemp
           y = ytemp * cosinc + ztemp * sininc
           z = -ytemp * sininc + ztemp * cosinc


           
           ;Approximate SB variation at these sub-points
           ;we ignore scattering phase function effects
           ;img = disk_imager_simplified(s, x, y, z, dv, limit_flag)          
           ;disk_imager_simplified is much faster for optimization,
           ;but in the end you have the run the full calculation
           ;at the highest resolution anyway, so there isn't much
           ;savings.
           ;disk_imager takes our grid of points, calculates the disk
           ;density, illuminates with starlight, and calculates a disk
           ;image cube for the subarray of pixels


           img = disk_imager(s, x, y, z, r, dv, cosscattang, rdust, drdust, rdust_blowout, Qsca, tsublimate) 
           
           ;Now integrate all sub-pixels
           tempimg = img[*,subpixelrows,*]
           for inxy = 1,nxy-1 do tempimg += img[*,subpixelrows+inxy,*]
           img = tempimg[subpixelrows,*,*]
           for inxy = 1,nxy-1 do img += tempimg[subpixelrows+inxy,*,*]

           ;if ix ge 120 and iy eq 123 and s.starID eq 2062 then begin
           ;   if ix eq 121 and nz eq 64 then openw,lun,'/local/data/helen1/cstark/exovista_output/1/junk.txt',/get_lun,width=200 else openw,lun,'/local/data/helen1/cstark/exovista_output/1/junk.txt',/get_lun,/append,width=200
           ;   diff = abs(img-previmg)/previmg
           ;   maxdiff = max(diff)
           ;   j = where(diff eq max(diff))
           ;   printf,lun,ix,iy,r_arcsec[ix,iy],tol,' | ',nxy,nz,img[12],previmg[12],maxdiff[0]

              

           ;   free_lun,lun
           ;endif
           
           if iteration gt 0 then begin

              diff = abs(img-previmg)/previmg
              precision[ix:ix+nsubarraypix-1,iy:iy+nsubarraypix-1] = max(diff,dimension=3)


              
              if max(diff) lt tol then begin
                 finished_this_pixel++
              endif 

              if finished_this_pixel eq 0 and nz ge maxnz then begin
                 finished_this_pixel++
              endif

              if finished_this_pixel eq 1 and nxy ge maxnxy then begin
                 finished_this_pixel++ 
              endif

           endif
           previmg = img

           
           
           prevnxy = nxy
           prevnz = nz

           if nz gt maxnz_used then maxnz_used = nz
           if nxy gt maxnxy_used then maxnxy_used = nxy


           ;If the tolerance has not been met in the z direction, double
           ;the number of points in the z direction
           if finished_this_pixel eq 0 then nz *= 2
           ;If the tolerance has not been met in the xy direction, double
           ;the number of points in the xy direction
           if finished_this_pixel eq 1 then nxy *= 2


           iteration++


        endwhile

        
        masterimg[ix:ix+nsubarraypix-1,iy:iy+nsubarraypix-1,*] = img 
     endfor
     print,ix,maxnxy_used,maxnz_used,tol0
  endfor

  tend = systime(/sec)
  if not keyword_set(quiet) then print,'Run time = ',tend-tstart,' seconds.'


  masterimg = [[[masterimg]],[[precision]]] ;concatenate them together
  return,masterimg
  
end	   
