pro calibrate_exozodi

  routinename='generate_scene'
  exovistapath=routine_info(routinename,/source)
  exovistapath=strmid(exovistapath.path,0,strlen(exovistapath.path)-strlen(routinename)-4)
  
  generate_solarsystem,s,distance=10.,inclination=60.,pa=0.
  s.disk[1:2].r = s.disk[0].r
  s.disk[1:2].nzodis = 0.       ;ignore the cold components

  
  ;Now get V band flux from disk
  pixscale = 0.004 ;arcsec
  pixscale_AU = pixscale*s.dist
  r0pix = 1.0/pixscale_AU
  undefine,lambda_disk
  generate_scene,s,seed=seed,lambdamin=0.55,lambdamax=0.9,lambda_disk=lambda_disk,pixscale=pixscale,npix=150

  ;Calculate stellar flux
  fstardisk = get_stellar_flux(s,lambda_disk,path=exovistapath)     

  disk_contrast_image = readfits('./output/-1-HIP_-TYC_SUN*5778.00.fits',ext=2)

  disk_image = disk_contrast_image[*,*,0] * fstardisk[0]
  disk_image2 = disk_contrast_image[*,*,n_elements(fstardisk)-1] * fstardisk[n_elements(fstardisk)-1]
  j = where(finite(disk_image) ne 1)
  if j[0] ne -1 then disk_image[j] = 0.
  tvscl,disk_image^0.1
  npix = size(disk_image,/dim)
  npix = npix[0]
  r0pix = 1.0/pixscale_AU
  dpix = 1
  fdisk = total(disk_image[(npix/2+r0pix)-dpix:(npix/2+r0pix)+dpix,npix/2-dpix:npix/2+dpix])

  ;The following code shows the user
  ;visually where the photometric aperture is on the disk
  ;without modifying the disk image
  temp = disk_image
  temp[where(temp eq 0)] = min(temp[where(temp gt 0)])
  temp[(npix/2+r0pix)-dpix:(npix/2+r0pix)+dpix,npix/2-dpix:npix/2+dpix] = 2*max(temp)
  tvscl,alog10(temp)
  
  
  ;output of dustmap is Jy per pix
  ;we want mags per square arcsecond
  ;First convert fdisk to mags
  F0=calc_flux_zero_point(0.55,/verbose,/jy) ;flux zero point in Jy
  desired_brightness = F0 * 10^(-0.4 * 22.) ;22 mag per square arcsecond -> Jy per square arcsecond
  aperture_size_arcsec2 = ((dpix*2+1)*pixscale)^2.
  measured_brightness = fdisk/aperture_size_arcsec2
  print,measured_brightness,desired_brightness,desired_brightness/measured_brightness
  pause

  ;This just makes a plot that shows radial color variation due to
  ;how we vary eta with grain size
  r = rgen(npix,npix)*pixscale_AU
  y = (disk_image2-disk_image)/disk_image
  plot,r[npix/2:npix-1,npix/2],y[npix/2:npix-1,npix/2]
  pause
  
  ;Take a radial cut of surface brightness and plot
  temp = total(disk_image[npix/2:npix-1,npix/2-dpix:npix/2+dpix-1],2)
  window,0,xsize=600,ysize=600
  r = (findgen(n_elements(temp))+0.5)*pixscale*s.dist
  print,s.disk[0].r
  plot,r,temp,/xlog,/ylog,/xs,xrange=[0.1*s.disk[0].r,10*s.disk[0].r]
  loadct,39
  print,temp[where(abs(r - s.disk[0].r) eq min(abs(r-s.disk[0].r)))]
  
  n0 = reform(temp[where(abs(r - s.disk[0].r) eq min(abs(r-s.disk[0].r)))])
  n0 = n0[0]
  oplot,r,n0*(r/s.disk[0].r)^(-2.0),color=!red
  
  ;TO DO
  ;metallicity
;background data cube
  ;proper motion -- include in stellar info, how to include in bg?
  ;random disk compositions?
;post ExoVista



end




pro checknoise

  lambda0 = 0.55 ;microns
  diameter = 8.                ;diameter of telescope in m 
  limiting_dmag = 26.5
  npix = 250
  
  pixscale = 0.25 * (lambda0*1e-6)/diameter * (180./!dpi) * 60. * 60. ;arcsec
  npixcore = !pi * (0.7 * (lambda0*1e-6)/diameter * (180./!dpi) * 60. * 60.)^2. / pixscale^2.


  generate_solarsystem,s,distance=10.,inclination=60.,pa=0.
  s.disk[1:2].r = s.disk[0].r
  s.disk[1:2].nzodis = 0.       ;ignore the cold components


  pixscale_AU = pixscale*s.dist
  r0pix = 1.0/pixscale_AU

  print,npix
  print,npix/2.+r0pix
  if r0pix ge npix/2-2 then stop,'Must increase # of pixels.'

  
  fstar = get_stellar_flux(s,lambda0)     
  flim = 10.^(-0.4*limiting_dmag)*fstar

  
  ;Make scene
  generate_scene,s,seed=seed,disk_contrast_image=disk_contrast_image,lambdamin=lambda0,lambdamax=1.0,lambda_disk=lambda_disk,pixscale=pixscale,/flatSB,npix=npix
  disk_contrast_image = reform(disk_contrast_image[*,*,0])

  
  ;Grab the V band SB
  disk_image = disk_contrast_image[*,*] * fstar[0]
  j = where(finite(disk_image) ne 1)
  if j[0] ne -1 then disk_image[j] = 0.

  ;Display where we're measuring the disk SB
  dpix = 2
  temp = disk_image
  temp[(npix/2+r0pix)-dpix/2.:(npix/2+r0pix)+dpix/2.-1,npix/2-dpix/2.:npix/2+dpix/2.-1] = 2*max(temp)
  tvscl,alog10(temp)

  ;Now calculate the disk flux
  fdisk = disk_image[npix/2+r0pix,npix/2]*npixcore

  ;We want to know what the precision of disk flux calculation
  ;needs to be. The following prints the flux of our detection
  ;limit divided by the disk flux for 1 zodi. We should make the
  ;disk flux tolerance <10% of this ratio for 1 zodi.
  print,flim/fdisk
 

end




pro compare_resolution

  restore,filename='temp_img-linearz_spacing.sav'
  restore,filename='temp_img-linearz_spacing-highres10x10000.sav'

  diff = abs(img1-img2)
  reldiff = diff/img2
  print,minmax(reldiff)
  tvscl,reldiff^0.1
  print,median(reldiff)
  print,mean(reldiff)
  print,stddev(reldiff)

  h = histogram(reldiff,min=0.00001,max=0.01,binsize=0.00001)
  x = findgen(0.01/0.00001)*0.00001
  
  plot,x,h,psym=10,/xs,xrange=[0.00001,0.001]

end
